﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VHAReportViewer;

public partial class ReportStatusCounts : System.Web.UI.Page
{

    #region Variable Declarations

    private ReportViewerHandler _reportViewerHandler;
    private UserAccountManager _currentUser;
    //TBIExceptionHandler _tbiexception = new TBIExceptionHandler();
    string _reportName = "VeteransScreeningQuestions";

    #endregion

    #region Protected Methods

    protected void Page_Load(object sender, EventArgs e)
    {
        if (AccessAllowed())
        {
            ReportViewer1.Visible = false;

            if (!Page.IsPostBack)
            {
                ViewState["ReportViewerHandler"] = _reportViewerHandler = new ReportViewerHandler();
            }
            else
            {
                _reportViewerHandler = (ReportViewerHandler)ViewState["ReportViewerHandler"];
            }
            EnableButtonRunReport();
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }
    protected void btnRunReport_Click(object sender, EventArgs e)
    {

        try
        {
            if (!String.IsNullOrEmpty(SSNAndFacilitySelect1.FacilityStationNumber))
            {
                ReportViewer1.Reset();

                _reportViewerHandler.ClearParams();

                string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
                UserAccountManager _currentUser1 = (UserAccountManager)HttpContext.Current.User;
                _reportViewerHandler.AddReportVariable("VeteranSSN", this.SSNAndFacilitySelect1.SSN);
                _reportViewerHandler.AddReportVariable("Username", _currentUser1.FullName);
                _reportViewerHandler.AddReportVariable("FacilityId", this.SSNAndFacilitySelect1.FacilityStationNumber);

                ReportViewer1.ServerReport.ReportPath = _reportName;
                ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));

                if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
                {
                    ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
                    //ReportViewer1.ServerReport.ReportPath = config.BaseReportPath + ReportViewer1.ServerReport.ReportPath;
                }
                _reportViewerHandler.SetServerReportParameters(ReportViewer1);

                ReportViewer1.Visible = true;
                ReportViewer1.ProcessingMode = ProcessingMode.Remote;
                ReportViewer1.Visible = true;
                ReportViewer1.ServerReport.Refresh();

            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100016", "Get() ReportData");
        }
    }

    #endregion

    #region Private Methods Declarations

    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return (_currentUser.IsInRole(16) || _currentUser.IsInRole(17) || _currentUser.IsInRole(18));
    }

    private void EnableButtonRunReport()
    {
    }

    #endregion

}
